
--Rain parameters
kPPS = 10;               -- Number of particles generated per second
kGravity = 3800;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("pedal");
  SetBlendMode(kBlendNormal);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(500);
TestDone = NewTimeout(3000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-10, -10, 0), Vec3(10,10, 0) );
   InitVelocity( "vRange", Vec3(0, 0, 0), Vec3(60,60, 0) );
   InitScale( "fRange", 1, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
   DoColor("cFade",
      Color(40, 221,252, 1), 1500,
      Color(1, 1, 1, 0), 1500,
      Color(.2, .2, .2, 0));
   DoScale("fScale",
      .3, 500,
      .1, 500);
   Do("expire", 3000)

DoUp( "vRotate", -.5, .5 );


end

